local assets =
{
    Asset("ANIM", "anim/ast_item_2.zip"),
	Asset("ATLAS", "images/inventoryimages/s.xml"),
	Asset("ATLAS", "images/inventoryimages/sa.xml"),
	Asset("ATLAS", "images/inventoryimages/h2.xml"),
	Asset("ATLAS", "images/inventoryimages/o2.xml"),
	Asset("ATLAS", "images/inventoryimages/pb.xml"),
	Asset("ATLAS", "images/inventoryimages/c.xml"),
	Asset("ATLAS", "images/inventoryimages/tube.xml"),
}
STRINGS.NAMES.S = "硫磺"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.S= "火药的配方是一硝二黄三木炭"
STRINGS.NAMES.SA = "海藻酸钠"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SA= "可以应用在食品和化学方面"
STRINGS.NAMES.H2 = "氢气"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.H2= "天干物燥，小心火烛"
STRINGS.NAMES.O2 = "氧气"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.O2= "绝佳的燃料"
STRINGS.NAMES.TUBE = "试管"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUBE= "说到化学那就是试管了"
STRINGS.NAMES.C = "碳"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.C= "碳基生命体的根本元素"
STRINGS.NAMES.PB = "铅"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PB= "以前的罐头就是用这种有毒重金属作为封口的"
local function buildgene(lei)

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ast_item_2")
    inst.AnimState:SetBuild("ast_item_2")
    inst.AnimState:PlayAnimation(lei)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
--分界线
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = lei
    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..lei..".xml"
    inst:AddComponent("selfstacker")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM


    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab(lei, fn, assets)

end
local function o2fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("cuisine")
    inst.AnimState:SetBuild("cuisine")
    inst.AnimState:PlayAnimation("water")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
	inst:AddComponent("tradable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "water"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/water.xml"
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	inst:AddComponent("edible")
    inst.components.edible.foodtype = "GENERIC"
    inst.components.edible.healthvalue = 1
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = 0
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERFAST)
    inst.components.perishable:StartPerishing()
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return 
    buildgene("s"),
	buildgene("sa"),
	buildgene("h2"),
	buildgene("tube"),
	buildgene("c"),
	buildgene("o2"),
    buildgene("pb",true)
	

